﻿--     ⚠  WARNING  ⚠
--      ⚠ ACHTUNG ⚠
--       ⚠  警告 ⚠
-- DO NOT run this on a production system.
-- This script deletes all generated data including PATIENTS and DOCUMENTS and PROVIDERS and AUDITS and LOGS from the database.
-- The only way to recover would be to restore the database from a backup.


-- Tables with no foreign key constraints can be directly truncated
TRUNCATE TABLE hips.HospitalHealthProviderIndividual
TRUNCATE TABLE hips.PcehrMessageQueue
TRUNCATE TABLE hips.PcehrAudit
TRUNCATE TABLE hips.IhiLookupAlert
TRUNCATE TABLE hips.IhiLookupAudit
TRUNCATE TABLE hips.HL7MessageLog
TRUNCATE TABLE hips.HpiiLookupAudit
TRUNCATE TABLE hips.SystemErrorLog
TRUNCATE TABLE hips.RemoveAudit
TRUNCATE TABLE hips.ClinicalDocumentVersion
TRUNCATE TABLE hips.HospitalPatientHistory
TRUNCATE TABLE hips.HealthProviderOrganisationPatient
TRUNCATE TABLE hips.PatientMasterIhiHistory
TRUNCATE TABLE hips.PatientMasterIhi
TRUNCATE TABLE hips.PatientMasterName
TRUNCATE TABLE hips.PatientMasterHistory
TRUNCATE TABLE hips.DownloadedDocument

-- These join tables have cascading deletes (to Address and Contact) 
DELETE hips.PatientMasterAddress
DELETE hips.PatientMasterContact

-- Tables with foreign key constraints need a delete and reseed
DELETE hips.ClinicalDocument
DBCC CHECKIDENT('hips.ClinicalDocument', RESEED)
DELETE hips.Episode
DBCC CHECKIDENT('hips.Episode', RESEED)
DELETE hips.HospitalPatient
DBCC CHECKIDENT('hips.HospitalPatient', RESEED)
DELETE hips.PatientMaster
DBCC CHECKIDENT('hips.PatientMaster', RESEED)

-- Avoid deleting the dummy record for unknowns
DELETE hips.HealthProviderIndividual WHERE HealthProviderIndividualId <> -1
DBCC CHECKIDENT('hips.HealthProviderIndividual',RESEED)

-- Avoid deleting the preloaded information for Suffix and Title
DELETE hips.Suffix WHERE SuffixId>23
DBCC CHECKIDENT('hips.Suffix',RESEED)
DELETE hips.Title WHERE TitleId>12
DBCC CHECKIDENT('hips.Title',RESEED)